//---------------------------------------------------------------
// Fichero:  sietepuntas.asy
// Objetivo: Dibujar una estrella de siete puntas
// Fecha:    M.11.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3cm);

// Grosor de las líneas
defaultpen(1);

// Las dos circunferencias
draw(unitcircle, gray);
draw(scale(2)*unitcircle, gray);

// Los puntos de la estrella
pair[] Estrella;

// Calculamos los puntos de la estrella
real Ang=180/7;
for ( int i=0 ; i<14 ; ++i )
    { Estrella[i] = (i%2+1)*dir(i*Ang); }

// Dibujamos la estrella
for ( int i=0 ; i<13 ; ++i )
    { draw (Estrella[i] -- Estrella[i+1]); }
draw (Estrella[0] -- Estrella[13]);
