//---------------------------------------------------------------
// Fichero:  figura3.asy
// Objetivo: Mostrar la figura 3
// Fecha:    L.17.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle() markangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.5cm);

// Grosor de las líneas
defaultpen(1);

// La base de la altura
pair A=(0,0);

// El vértice izquierdo
pair B=(-7,0);

// El vértice derecho
pair C=(3.12,0);

// El vértice superior
pair D=(0,5.9);

// Los ángulos
pen FormAng=fontsize(8pt)+deepgreen;
pen FormArc=0.5bp+deepgreen;
markangle(Label("$40^\circ$",FormAng),
          radius=8mm, A, B, D, FormArc);
markangle(Label("$62^\circ$",FormAng),
          radius=5mm, D, C, A, FormArc);
markrightangle(D, A, C, 2mm, 1bp+gray);

// La separación entre las flechas y los elementos
real Separacion = 0.5;

// Las flechas
pen FormatoFlecha=mediumblue+0.75bp;
draw(A+Separacion*(0,-1) -- B+Separacion*(0,-1), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));
draw(A+Separacion*(0,-1) -- C+Separacion*(0,-1), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));

// Los textos
pen FormatoTexto=fontsize(8pt)+Helvetica(series="b",shape="n");
label("7", (A+B)/2+Separacion*(0,-2), deepgreen+FormatoTexto);
label("x", (C+A)/2+Separacion*(0,-2), red+FormatoTexto);

// Dibujamos el triángulo
draw(A -- D, gray);
draw(B -- C -- D -- B);
