//---------------------------------------------------------------
// Fichero:  figura6a.asy
// Objetivo: Representar el pentágono básico de la teselación
// Fecha:    L.17.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.5cm);

// Grosor de las líneas
defaultpen(1);

// Formamos el pentágono
pair A = (0,0);
pair B = 2*dir(60);
pair E = 2*dir(120);
pair C = B+dir(120);
pair D = E+dir(60);

// Los ángulos
pen FormAng=fontsize(8pt)+deepgreen;
pen FormArc=0.5bp+deepgreen;
markangle(Label("$60^\circ$",FormAng), radius=8mm, B, A, E, FormArc);
markangle(Label("$120^\circ$",FormAng), radius=4mm, C, B, A, FormArc);
markangle(Label("$120^\circ$",FormAng), radius=4mm, D, C, B, FormArc);
markangle(Label("$120^\circ$",FormAng), radius=4mm, E, D, C, FormArc);
markangle(Label("$120^\circ$",FormAng), radius=4mm, A, E, D, FormArc);

// Representamos el pentágono
draw(A -- B -- C -- D -- E -- A);
