//---------------------------------------------------------------
// Fichero:  figura2.asy
// Objetivo: Mostrar la figura 2
// Fecha:    M.18.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle() markangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.5cm);

// Grosor de las líneas
defaultpen(1);

// El vértice de la izquierda
pair A=(0,0);

// El vértice de la derecha
pair B=(sqrt(3),0);

// El punto en vertical
pair Q=(sqrt(3),1);

// El vértice de arriba
pair C=(sqrt(3),sqrt(3));

// Los ángulos
pen FormAng=fontsize(8pt)+deepgreen;
pen FormArc=0.5bp+deepgreen;
markangle(Label("$30^\circ$",FormAng), radius=10mm, B, A, Q, FormArc);
markangle(Label("$15^\circ$",FormAng), radius=20mm, Q, A, C, FormArc);
markrightangle(C, Q, B, 4mm, 1bp+gray);

// La separación entre las flechas y los elementos
real Separacion = 0.1;

// Las flechas
pen FormatoFlecha=mediumblue+0.75bp;
draw(Q+Separacion*(1,0) -- C+Separacion*(1,0), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));

// Los textos
pen FormatoTexto=fontsize(8pt)+Helvetica(series="b",shape="n");
label("2", (A+Q)/2+Separacion*(0.5,-0.5), deepgreen+FormatoTexto);
label("x", (Q+C)/2+Separacion*(2,0), red+FormatoTexto);

// Dibujamos las líneas
draw(Q -- A -- B -- C -- A);
