//---------------------------------------------------------------
// Fichero:  figura.asy
// Objetivo: Mostrar un ejemplo
// Fecha:    J.13.2.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

//markangle() y markrightangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(16cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A0=(0,0), B0=(4,0), C0=(4,2);
pair A, B, C;

// El formato de texto
pen Formato=black+fontsize(12pt);

// Dibujamos tres triángulos
for ( int i=0 ; i<3 ; ++i )
    {
    // Desplazamos los puntos
    transform T=shift((10i)*B0)*scale(2i+4);
    A = T*A0;
    B = T*B0;
    C = T*C0;

    // Los ángulos
    markangle(Label("$\alpha$",Formato), radius=10mm, B, A, C, 1bp+blue);
    markrightangle(A, B, C, 2mm, 1bp+gray);

    // El triangulo
    draw(A -- B -- C -- cycle);

    // Los nombres
    string Num=string(i+1);
    label("$A_"+Num+"$", A, W, Formato);
    label("$B_"+Num+"$", B, E, Formato);
    label("$C_"+Num+"$", C, N, Formato);
    label("$a_"+Num+"$", (B+C)/2, E, Formato);
    label("$b_"+Num+"$", (A+C)/2, NW, Formato);
    label("$c_"+Num+"$", (A+B)/2, S, Formato);
    }
