//---------------------------------------------------------------
// Fichero:  figura2.asy
// Objetivo: Realizar la figura 2
// Fecha:    S.22.2.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle() y markrightangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,2.3cm);

// Grosor de las líneas
defaultpen(0.5);

// Dos puntos de la circunferencia
pair A=dir(aSin(0.7)), B=dir(-aSin(0.7));

// El punto medio
pair C=(A.x,0);

// Los segmentos
draw(A -- B);
draw((0,0) -- C);
draw((0,0) -- A);
draw((0,0) -- B);

// El formato de texto
pen Formato=black+fontsize(5pt);

// Los ángulos
markangle(Label("$\frac{\alpha}{2}$",Formato), radius=3mm, B, (0,0), C, blue);
markangle(Label("$\frac{\alpha}{2}$",Formato), radius=2mm, C, (0,0), A, blue);
markrightangle((0,0), C, A, 1.5mm, 0.5bp+gray);

// Los textos
label("7", (A+B)/2, E, Formato);
label("5", A/2, NW, Formato);
label("5", B/2, SW, Formato);
label("3.5", (C+A)/2, W, Formato);
label("3.5", (C+B)/2, W, Formato);
