//---------------------------------------------------------------
// Fichero:  figura3.asy
// Objetivo: Realizar la figura 3
// Fecha:    S.22.2.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle() y markrightangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,1.5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(3.57,0), C=(3.57,3.5);

// El formato de texto
pen Formato=black+fontsize(8pt);

// El triángulo
draw(A -- B -- C -- cycle);

// Los ángulos
markangle(Label("$\frac{\alpha}{2}$",Formato), radius=5mm, B, A, C, 1bp+blue);
markrightangle(A, B, C, 2mm, 1bp+gray);

// La descripción de los lados
label("5", (A+C)/2, NW, Formato);
label("3,5", (B+C)/2, E, Formato);
