//---------------------------------------------------------------
// Fichero:  resolucion1.asy
// Objetivo: Ilustrar la resolución 1
// Fecha:    V.14.2.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

//markangle() y markrightangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(25.22,0), C=(25.22,30.69);

// El formato de texto
pen Formato=black+fontsize(10pt);

// El triángulo
draw(A -- B -- C -- cycle);

// Los ángulos
markangle(Label("$50^\circ35^\prime$",Formato), radius=5mm, B, A, C, 1bp+blue);
markrightangle(A, B, C, 2mm, 1bp+gray);

// La descripción de los lados
label("25,22", (A+B)/2, S, Formato);
label("x", (B+C)/2, E, Formato);
