//---------------------------------------------------------------
// Fichero:  esquema.asy
// Objetivo: Mostrar el esquema del problema
// Fecha:    S.15.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle() markangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(0.5);

// El vértice de la izquierda
pair A=(0,0);

// El vértice de la derecha
pair B=(83,0);

// El vértice de arriba
pair C=(83,63);

// El punto donde empezamos
pair D=(50,0);

// Los ángulos
pen FormAng=fontsize(6pt)+deepgreen;
pen FormArc=0.5bp+deepgreen;
markangle(Label("$62^\circ$",FormAng), radius=5mm, B, D, C, FormArc);
markangle(Label("$37^\circ$",FormAng), radius=8mm, D, A, C, FormArc);
markrightangle(C, B, D, 2mm, 0.5bp+black);

// La separación entre las flechas y el objeto
real Separacion = 2;

// Las flechas que marcan los segmentos
pen FormatoFlecha=mediumblue+0.5bp;
draw(B+Separacion*(3,0) -- C+Separacion*(3,0), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));
draw(B+Separacion*(0,-2) -- D+Separacion*(0,-2), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));
draw(A+Separacion*(0,-2) -- D+Separacion*(0,-2), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));

// Los textos
pen FormatoTexto=fontsize(6pt)+Helvetica(series="n",shape="n");
label("A", A, W, black+FormatoTexto);
label("B", B, E, black+FormatoTexto);
label("C", C, N, black+FormatoTexto);
label("D", D, NW, black+FormatoTexto);
label("h", (B+C)/2+Separacion*(4,0), red+FormatoTexto);
label("d", (D+B)/2+Separacion*(0,-4), red+FormatoTexto);
label("50", (A+D)/2+Separacion*(0,-4), deepgreen+FormatoTexto);

// Dibujamos el triángulo
draw(A -- B -- C -- A);

// El segmento auxiliar
draw(C -- D, black);

// Marcamos los puntos importantes
pen FormatoPunto=3bp+black;
dot(A,FormatoPunto);
dot(B,FormatoPunto);
dot(C,FormatoPunto);
dot(D,FormatoPunto);
