#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  trirec.py
# Objetivo: Resolver cualquier triángulo rectángulo
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    S.22.3.2025
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
#--------------------------------------------------------------------

#------------------------------------------------
# Uso del programa:
#
# El vértice A es el del ángulo recto
# Los vértices B y C son los de los ángulos agudos
# El lado a es la hipotenusa
# Los lados b y c son los catetos
# Cada lado lleva el mismo nombre que el vértice opuesto
# Los valores de los ángulos son las variables B y C
# Los valores de los lados son las variables a, b, y c
# El programa se invoca con dos datos, escribiendo nombre y valor
# Ejemplos: ./trirec.py a 32 b 21 | ./trirec.py B 59 c 19
# Los parámetros se pueden escribir en cualquier orden
# Los datos se tratan como números enteros
#------------------------------------------------

#------------------------------------------------
# Módulos
#------------------------------------------------

# Para leer la línea de órdenes
import sys

# Para las funciones trigonométricas
import math

#------------------------------------------------
# Función auxiliar
#------------------------------------------------

# Convierte un ángulo en grados, minutos y segundos
def GMS(Ang):
    Grado, Decimal = divmod(Ang,1)
    Grado = int(Grado)
    Decimal = 60*Decimal
    Minuto, Decimal = divmod(Decimal,1)
    Minuto = int(Minuto)
    Segundo = 60*Decimal
    return str(Grado) + ' ' + str(Minuto) + ' ' + str(Segundo)

#------------------------------------------------
# El programa
#------------------------------------------------

# Los distintos elementos que manejamos
ListaElementos = ['B','C','a','b','c']

# Al principio no tenemos ningún dato
esDato = {}
for Elemento in ListaElementos:
   esDato[Elemento] = 0

# Leemos los datos de la línea de órdenes
for i,Arg in enumerate(sys.argv):
    if Arg in ListaElementos: esDato[Arg] = 1
    if Arg == 'B': B=int(sys.argv[i+1])
    if Arg == 'C': C=int(sys.argv[i+1])
    if Arg == 'a': a=int(sys.argv[i+1])
    if Arg == 'b': b=int(sys.argv[i+1])
    if Arg == 'c': c=int(sys.argv[i+1])

# Imprimimos los datos
print 'Datos'
for Elemento in ListaElementos:
    if esDato[Elemento]: print Elemento, '=', eval(Elemento)

# Vemos cuántos lados nos han pasado
NumLados = esDato['a'] + esDato['b'] + esDato['c']

# Si tenemos dos lados
if NumLados == 2:
    if not esDato['a']:
        a = math.sqrt(b**2+c**2)
        B = math.atan(float(b)/c)
    if not esDato['b']:
        b = math.sqrt(a**2-c**2)
        B = math.acos(float(c)/a)
    if not esDato['c']:
        c = math.sqrt(a**2-b**2)
        B = math.asin(float(b)/a)

    B = math.degrees(B)
    C = 90-B

# Si tenemos un lado
if NumLados == 1:
    if not esDato['B']: B = 90-C
    if not esDato['C']: C = 90-B

    if esDato['a']:
        b = a*math.sin(math.radians(B))
        c = a*math.sin(math.radians(C))
    if esDato['b']:
        a = b/math.sin(math.radians(B))
        c = b/math.tan(math.radians(B))
    if esDato['c']:
        a = c/math.sin(math.radians(C))
        b = c/math.tan(math.radians(C))

# Convertimos los ángulos en grados, minutos y segundos
B = GMS(B)
C = GMS(C)

# Imprimimos los resultados
print 'Resultados'
for Elemento in ListaElementos:
    if not esDato[Elemento]: print Elemento, '=', eval(Elemento)
