//---------------------------------------------------------------
// Fichero:  triangulo.asy
// Objetivo: Dibujar un triángulo rectángulo
// Fecha:    D.23.3.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle() markangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(4,0), C=(4,3);

// Los ángulos
pen FormAng=fontsize(12pt)+black;
pen FormArc=0.5bp+black;
markangle(Label("$\alpha$",FormAng), radius=6mm, B, A, C, FormArc);
markrightangle(A, B, C, 4mm, 0.5bp+gray);

// El triangulo
draw(A -- B -- C -- cycle);

// Los nombres
pen FormatoTexto=black+fontsize(10pt)+Helvetica(series="b",shape="n");
label("p", (A+B)/2, S, FormatoTexto);
label("q", (B+C)/2, E, FormatoTexto);
label("r", (A+C)/2, NW, FormatoTexto);
