//---------------------------------------------------------------
// Fichero:  solucion3.asy
// Objetivo: Mostrar la solución 3
// Fecha:    S.25.10.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8.8cm);

// Dimensiones de los ejes
real Xmin = -5, Xmax = 5, Ymin = -3, Ymax = 3, Extra = 0.25;

// Los vértices de la solución
pair A=(0,1), B=(2,0), C=(4,2);

// La solución
fill(A -- B -- C -- cycle, lightgreen);

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),1bp+gray));

// Grosor de las líneas
defaultpen(1);

// Los ejes
draw((0,Ymin-Extra) -- (0,Ymax+Extra));
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Las semirrectas
draw(A -- B -- C -- cycle,1.5bp+heavygreen);

// Los puntos
dot (A, 5bp+heavygreen);
dot (B, 5bp+heavygreen);
dot (C, 5bp+heavygreen);
