//---------------------------------------------------------------
// Fichero:  solucion6.asy
// Objetivo: Mostrar la solución 6
// Fecha:    S.25.10.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8.8cm);

// Dimensiones de los ejes
real Xmin = -8, Xmax = 6, Ymin = -2, Ymax = 4, Extra = 0.25;

// Los extremos de las semirrectas
pair A=(-4,3), B=(4,-1);

// La solución
fill((-8,3) -- A -- B -- (-8,-1) -- cycle, lightgreen);

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),1bp+gray));

// Grosor de las líneas
defaultpen(1);

// Los ejes
draw((0,Ymin-Extra) -- (0,Ymax+Extra));
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Las líneas
pen Punteado = linetype(new real[] {2,2});
draw((-8,3) -- A,1.5bp+white);
draw((-8,3) -- A,1.5bp+heavygreen+Punteado);
draw(A -- B -- (-8,-1),1.5bp+heavygreen);

// Los puntos
dot (A, 5bp+gray);
dot (A, 3bp+white);
dot (B, 5bp+heavygreen);
