//---------------------------------------------------------------
// Fichero:  solucion5.asy
// Objetivo: Mostrar la solución 5
// Fecha:    L.27.10.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8.8cm);

// Dimensiones de los ejes
real Xmin = -1, Xmax = 10, Ymin = -1, Ymax = 6, Extra = 0.25;

// Los vértices de la solución
pair A=(0,0), B=(5,0), C=(3,2), D=(0,3);

// La solución
fill(A -- B -- C -- D -- cycle, lightgreen);

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),1bp+gray));

// Grosor de las líneas
defaultpen(1);

// Los ejes
draw((0,Ymin-Extra) -- (0,Ymax+Extra));
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Las semirrectas
pen Punteado = linetype(new real[] {2,2});
draw(B -- C -- D,1.5bp+heavygreen);
draw(A -- B,1.5bp+white);
draw(A -- B,1.5bp+heavygreen+Punteado);
draw(A -- D,1.5bp+white);
draw(A -- D,1.5bp+heavygreen+Punteado);

// Los puntos
dot (C, 5bp+heavygreen);
dot (A, 5bp+gray);
dot (A, 3bp+white);
dot (B, 5bp+gray);
dot (B, 3bp+white);
dot (D, 5bp+gray);
dot (D, 3bp+white);
