//---------------------------------------------------------------
// Fichero:  solucion5.asy
// Objetivo: Mostrar la solución 5
// Fecha:    J.30.10.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Dimensiones de los ejes
real Xmin = -4, Xmax = 6, Ymin = -4, Ymax = 4, Extra = 0.25;

// Los vértices de la solución
pair A=(-3,-1), B=(3,1), C=(-1,3);

// La solución
fill((0,0) -- A -- arc((0,0),C,A) -- cycle, lightgreen);
fill(A -- B -- C -- cycle, lightgreen);
draw(A -- B -- C, 1.5bp+heavygreen);
draw(arc((0,0),C,A), 1.5bp+heavygreen);

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),1bp+gray));

// Grosor de las líneas
defaultpen(1);

// Los ejes
draw((0,Ymin-Extra) -- (0,Ymax+Extra));
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Los puntos
dot (A, 5bp+heavygreen);
dot (B, 5bp+heavygreen);
dot (C, 5bp+heavygreen);
