//---------------------------------------------------------------
// Fichero:  solucion.asy
// Objetivo: Mostrar la solución
// Fecha:    V.24.10.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8.8cm);

// Dimensiones de los ejes
real Xmin = -4, Xmax = 8, Ymin = -3, Ymax = 5, Extra = 0.25;

// La solución
pair A=(-2,5), B=(-2,3), C=(6,-1), D=(8,-1);
fill(A -- B -- C -- D -- (Xmax, Ymax) -- cycle, lightgreen);

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),1bp+gray));

// Grosor de las líneas
defaultpen(1);

// Los ejes
draw((0,Ymin-Extra) -- (0,Ymax+Extra));
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Los segmentos
pen Punteado = linetype(new real[] {2,2});
draw(A -- B -- C,1.5bp+heavygreen);
draw(C -- D,1.5bp+white);
draw(C -- D,1.5bp+heavygreen+Punteado);

// Los puntos
dot (B, 5bp+deepgreen);
dot (C, 5bp+gray);
dot (C, 3bp+white);
