//---------------------------------------------------------------
// Fichero:  todo.asy
// Objetivo: Mostrar las tres rectas
// Fecha:    V.24.10.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8.8cm);

// Dimensiones de los ejes
real Xmin = -4, Xmax = 8, Ymin = -3, Ymax = 5, Extra = 0.25;

// Las cuatro esquinas del dibujo
pair ESW=(Xmin,Ymin), ENW=(Xmin,Ymax), ENE=(Xmax,Ymax), ESE=(Xmax,Ymin);

// Los extremos de las rectas
pair R1=(Xmin,4), R2=(Xmax,-2);
pair S1=(-2,Ymin), S2=(-2,Ymax);
pair T1=(Xmin,-1), T2=(Xmax,-1);

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),1bp+gray));

// Grosor de las líneas
defaultpen(1);

// Los ejes
draw((0,Ymin-Extra) -- (0,Ymax+Extra));
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Las rectas
pen Punteado = linetype(new real[] {2,2});
draw(R1 -- R2,1.5bp+magenta);
draw(S1 -- S2,1.5bp+magenta);
draw(T1 -- T2,1.5bp+white);
draw(T1 -- T2,1.5bp+magenta+Punteado);

// Las flechas
pair v=0.2*unit((1,2));
draw(R1+v -- R1+3v,blue,Arrow());
draw(R2+v -- R2+3v,blue,Arrow());
pair v=0.2*(1,0);
draw(S1+(0,0.5)+v -- S1+(0,0.5)+3v,blue,Arrow());
draw(S2-(0,0.5)+v -- S2-(0,0.5)+3v,blue,Arrow());
pair v=0.2*(0,1);
draw(T1+(0.5,0)+v -- T1+(0.5,0)+3v,blue,Arrow());
draw(T2-(0.5,0)+v -- T2-(0.5,0)+3v,blue,Arrow());

// Las ecuaciones
path Caja=box((-1.25,-0.25),(1.25,0.25));

pair Pos=(3,1);
fill(shift(Pos)*rotate(-aTan(0.5))*Caja,white);
label(rotate(-aTan(0.5))*"$x+2y=4$",Pos,fontsize(10pt));

pair Pos=(2,-1)+0.4*(0,-1);
fill(shift(Pos)*xscale(0.75)*Caja,white);
label("$y=-1$",Pos,fontsize(10pt));

pair Pos=(-2,1)+0.4*(-1,0);
fill(shift(Pos)*rotate(90)*xscale(0.75)*Caja,white);
label(rotate(90)*"$x=-2$",Pos,fontsize(10pt));
