//---------------------------------------------------------------
// Fichero:  enunciado1.asy
// Objetivo: Mostrar el enunciado 1
// Fecha:    D.23.11.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Los vértices de la zona
pair A=(0,3), B=(4,1), C=(5,2), D=(2,5);

// Grosor de las líneas
defaultpen(1);

// La zona
filldraw(A -- B -- C -- D -- cycle, lightgreen, heavygreen);

// Las líneas
pen Punteado = linetype(new real[] {2,2});
draw((B.x,0) -- B,0.5bp+gray+Punteado);
draw((0,B.y) -- B,0.5bp+gray+Punteado);
draw((C.x,0) -- C,0.5bp+gray+Punteado);
draw((0,C.y) -- C,0.5bp+gray+Punteado);
draw((D.x,0) -- D,0.5bp+gray+Punteado);
draw((0,D.y) -- D,0.5bp+gray+Punteado);

// Los ejes
draw((-0.5,0) -- (5.5,0));
draw((0,-0.5) -- (0,5.5));

// Los puntos
dot(A,3bp+heavygreen);
dot(B,3bp+heavygreen);
dot(C,3bp+heavygreen);
dot(D,3bp+heavygreen);

// Los textos de los ejes
pen FT=black+fontsize(6pt);
label("0",(0,0),SW,FT);
label("2",(2,0),S,FT);
label("4",(4,0),S,FT);
label("5",(5,0),S,FT);
label("1",(0,1),W,FT);
label("2",(0,2),W,FT);
label("3",(0,3),W,FT);
label("5",(0,5),W,FT);
