//---------------------------------------------------------------
// Fichero:  todo.asy
// Objetivo: Mostrar todas las rectas
// Fecha:    D.9.11.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(9cm);

// Dimensiones de los ejes
real Xmin = -25, Xmax = 650, Ymin = -25, Ymax = 300, Extra = 20;

// Los extremos de las rectas
pair R1=(0,220), R2=(220,0);
pair S1=(0,160), S2=(640,0);
pair T1=(0,Ymax), T2=(200,0);

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=50, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Las rectas
draw(R1 -- R2,1bp+magenta);
draw(S1 -- S2,1bp+magenta);
draw(T1 -- T2,1bp+magenta);
draw((0,0) -- T2,1bp+magenta);
draw((0,0) -- S1,1bp+magenta);

// Las ecuaciones
path Caja=box((-1.25,-0.25),(1.25,0.25));
pen FormatoTexto = black+fontsize(6pt);

pair Pos=(350,90);
real Ang=-aTan(0.25);
fill(shift(Pos)*rotate(Ang)*Caja,white);
label(rotate(Ang)*"$x+4y=640$",Pos,FormatoTexto);

pair Pos=(70,220);
real Ang=-aTan(1.5);
fill(shift(Pos)*rotate(Ang)*Caja,white);
label(rotate(Ang)*"$3x+2y=600$",Pos,FormatoTexto);

pair Pos=(110,90);
real Ang=-45;
fill(shift(Pos)*rotate(Ang)*Caja,white);
label(rotate(Ang)*"$x+y=220$",Pos,FormatoTexto);

pair Pos=(100,15);
real Ang=0;
fill(shift(Pos)*rotate(Ang)*Caja,white);
label(rotate(Ang)*"$y=0$",Pos,FormatoTexto);

pair Pos=(15,75);
real Ang=90;
fill(shift(Pos)*rotate(Ang)*Caja,white);
label(rotate(Ang)*"$x=0$",Pos,FormatoTexto);

// Las flechas
pair n=5*(0,1);
draw((60,5)+n -- (60,5)+4n,orange,Arrow());
draw((140,5)+n -- (140,5)+4n,orange,Arrow());

pair n=5*(1,0);
draw((5,40)+n -- (5,40)+4n,orange,Arrow());
draw((5,110)+n -- (5,110)+4n,orange,Arrow());

pair n=5*unit((-1,-4));
pair d=unit(S2-S1);
draw(S1+25d+n -- S1+25d+4n,orange,Arrow());
draw(S2-150d+n -- S2-150d+4n,orange,Arrow());

pair n=5*unit((-3,-2));
pair d=unit(T2-T1);
draw(T1+40d+n -- T1+40d+4n,orange,Arrow());
draw(T2-30d+n -- T2-30d+4n,orange,Arrow());

pair n=5*unit((-1,-1));
pair d=unit(R2-R1);
draw(R1+40d+n -- R1+40d+4n,orange,Arrow());
draw(R2-30d+n -- R2-30d+4n,orange,Arrow());
