//---------------------------------------------------------------
// Fichero:  paralelas.asy
// Objetivo: Mostrar varias rectas paralelas
// Fecha:    M.11.11.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Dimensiones de los ejes
real Xmin = -15, Xmax = 205, Ymin = -15, Ymax = 165, Extra = 0;

// Los vértices de la zona
pair O=(0,0), P=(0,160), Q=(80,140), R=(160,60), S=(200,0);

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=20, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(8pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// La zona
filldraw(O -- P -- Q -- R -- S -- cycle, lightgreen, heavygreen);

// Las rectas
int Ybajo=-20;
real X=-34*Ybajo/21;
pair O2=(X,Ybajo);
draw(O+(O-O2) -- O2, red);
label("21x+34y=\textbf{0}",O2+(0,-10),fontsize(8pt));

int Ybajo=140;
real X=(5440-34*Ybajo)/21;
pair P2=(X,Ybajo);
draw(P+(P-P2) -- P2, red);
label("21x+34y=\textbf{5440}",P2+(0,-10),fontsize(8pt));

int Ybajo=120;
real X=(6440-34*Ybajo)/21;
pair Q2=(X,Ybajo);
draw(Q+(Q-Q2) -- Q2, red);
label("21x+34y=\textbf{6440}",Q2+(0,-10),fontsize(8pt));

int Ybajo=40;
real X=(5400-34*Ybajo)/21;
pair R2=(X,Ybajo);
draw(R+(R-R2) -- R2, red);
label("21x+34y=\textbf{5400}",R2+(0,-10),fontsize(8pt));

int Ybajo=20;
real X=(2200-34*Ybajo)/21;
pair H=(40,40), H2=(X,Ybajo);
draw(H+(H-H2) -- H2, red);
label("21x+34y=\textbf{2200}",H2+(0,-10),fontsize(8pt));

int Ybajo=60;
real X=(4400-34*Ybajo)/21;
pair H=(80,80), H2=(X,Ybajo);
draw(H+(H-H2) -- H2, red);
label("21x+34y=\textbf{4400}",H2+(0,-10),fontsize(8pt));

int Ybajo=-20;
real X=(4200-34*Ybajo)/21;
pair S2=(X,Ybajo);
draw(S+(S-S2) -- S2, red);
label("21x+34y=\textbf{4200}",S2+(0,-10),fontsize(8pt));

// Los puntos
dot(O,5bp+heavygreen);
label("O",O,SW,black+fontsize(10pt));
dot(P,5bp+heavygreen);
label("P",P,NE,black+fontsize(10pt));
dot(Q,5bp+heavygreen);
label("Q",Q,NE,black+fontsize(10pt));
dot(R,5bp+heavygreen);
label("R",R,NE,black+fontsize(10pt));
dot(S,5bp+heavygreen);
label("S",S,NE,black+fontsize(10pt));

// La flecha grande
pair A=(190,90), B=A+2(21,34);
draw(A--B,red,Arrow(size=2.5mm));
real Ang=aTan(34/21);
label(rotate(Ang)*"21x+34y",(A+B)/2+0.25(-34,21),red+fontsize(10pt));
label(rotate(Ang)*"creciente",(A+B)/2-0.25(-34,21),red+fontsize(10pt));
