/*--------------------------------------------------------------------
 * Fichero:  cazasubmarina.c
 * Objetivo: Jugar a "Caza submarina"
 * Autor:    Pedro Reina
 * Fecha:    J.20.6.2002
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * Ficheros de cabecera
 *------------------------------------------------------------------*/

#include <stdio.h>   /* printf() gets()      */
#include <stdlib.h>  /* srand() rand() abs() */
#include <ctype.h>   /* toupper()            */

/*--------------------------------------------------------------------
 * Definicin de macros constantes
 *------------------------------------------------------------------*/

#define DIMENSION  5  /* Filas y columnas del mar  */
#define MAXDISPARO 5  /* Mximo nmero de disparos */

/*--------------------------------------------------------------------
 * Definicin de variables globales
 *------------------------------------------------------------------*/

/* Posicin del submarino, siempre entre 0 y DIMENSION-1 */
int FilaSubmarino, ColumnaSubmarino;

/*--------------------------------------------------------------------
 * Declaracin de funciones
 *------------------------------------------------------------------*/

void ColocaSubmarino (void);
int  Juega (void);
int  CalculaDistancia (int, int);
void MueveSubmarino (void);

/*--------------------------------------------------------------------
 * Programa principal
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * Funcin:  main()
 * Objetivo: Presentar el programa, lanzar el juego y decir el resultado
 * Entradas: Ninguna
 * Salidas:  0, que indica que no hay errores
 *------------------------------------------------------------------*/
int main (void)
  {
  int Resultado;

  printf ( "Caza submarina\n" );
  printf ( "==============\n" );

  ColocaSubmarino();
  Resultado = Juega();

  if ( Resultado == 0 )
    printf ("Blanco!\n");
  else
    printf ("Has perdido.\n");

  return 0;
  }

/*--------------------------------------------------------------------
 * Definicin de funciones
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * Funcin:  Juega()
 * Objetivo: Dirigir el juego
 * Entradas: Ninguna
 * Salidas:  La distancia del ltimo disparo al submarino
 *------------------------------------------------------------------*/
int Juega (void)
  {
  int  Distancia, Fila, Columna, Disparo;
  char Coordenadas[3];

  Disparo = 1;
  do
    {
    /* Pedimos las coordenadas del disparo */
    printf ("Disparo %d: ", Disparo);
    gets (Coordenadas);
    Disparo++;

    /* Calculamos el disparo con nmeros entre 0 y DIMENSION-1 */
    Fila = toupper (Coordenadas[0]) - 'A';
    Columna = Coordenadas[1] - '1';

    /* Informamos de la distancia */
    Distancia = CalculaDistancia (Fila, Columna);
    printf ("Distancia: %d\n", Distancia);

    MueveSubmarino();
    } while ( Distancia > 0 && Disparo <= MAXDISPARO );

  return Distancia;
  }

/*--------------------------------------------------------------------
 * Funcin:  ColocaSubmarino()
 * Objetivo: Colocar el principio del juego el submarino
 * Entradas: Ninguna, se usan nmeros aleatorios
 * Salidas:  Cambian las variables globales del submarino
 *------------------------------------------------------------------*/
void ColocaSubmarino (void)
  {
  srand(0);  /* Iniciamos el generador de nmeros aleatorios */

  FilaSubmarino = rand() % DIMENSION;
  ColumnaSubmarino = rand() % DIMENSION;
  }

/*--------------------------------------------------------------------
 * Funcin:  MueveSubmarino()
 * Objetivo: Mover aleatoriamente el submarino una casilla
 * Entradas: Las variables globales
 * Salidas:  Las variables globales
 *------------------------------------------------------------------*/
void MueveSubmarino (void)
  {
  int Aleatorio;

  /* Se cambia la fila al azar, abajo, arriba o sin cambio */
  Aleatorio = rand() % 3;
  switch ( Aleatorio )
    {
    case 0: FilaSubmarino++; break;
    case 1: FilaSubmarino--; break;
    }

  /* Se cambia la columna al azar, derecha, izquierda o sin cambio */
  Aleatorio = rand() % 3;
  switch ( Aleatorio )
    {
    case 0: ColumnaSubmarino++; break;
    case 1: ColumnaSubmarino--; break;
    }

  /* Controlamos que el submarino no se salga de lmites */
  if ( FilaSubmarino < 0 )
    FilaSubmarino = 0;
  if ( FilaSubmarino >= DIMENSION )
    FilaSubmarino = DIMENSION-1;
  if ( ColumnaSubmarino < 0 )
    ColumnaSubmarino = 0;
  if ( ColumnaSubmarino >= DIMENSION )
    ColumnaSubmarino = DIMENSION-1;
  }

/*--------------------------------------------------------------------
 * Funcin:  CalculaDistancia()
 * Objetivo: Calcular la distancia entre el disparo y el submarino.
 *           la distancia es el mayor nmero entre la diferencia de
 *           filas y la diferencia de columnas
 * Entradas: La fila y columna del disparo
 * Salidas:  La distancia
 *------------------------------------------------------------------*/
int CalculaDistancia (int Fila, int Columna)
  {
  int Distancia, DistanciaHorizontal, DistanciaVertical;

  DistanciaHorizontal = abs (Columna-ColumnaSubmarino);
  DistanciaVertical = abs (Fila-FilaSubmarino);

  if ( DistanciaHorizontal > DistanciaVertical )
    Distancia = DistanciaHorizontal;
  else
    Distancia = DistanciaVertical;

  return Distancia;
  }
