/*--------------------------------------------------------------------
 * FICHERO:  Informac.h
 * OBJETIVO: Definir el objeto "Informacin" del programa Solitario
 * AUTOR:    Pedro Reina
 * FECHA: S.7.8.1993
 * IDENTIFICADOR: Inf
 * FUNCIONES DISPONIBLES:
 *    Inf_ActualizaPantalla()
 *    Inf_Decrementa()
 *    Inf_DibujaMarco()
 *    Inf_Incrementa()
 *    Inf_Inicia()
 *------------------------------------------------------------------*/

#ifndef _INFORMACION_
#define _INFORMACION_

/*--------------------------------------------------------------------
 * Ficheros de cabecera
 *------------------------------------------------------------------*/

#include <Olimpo.h>

/*--------------------------------------------------------------------
 * Declaracin de funciones
 *------------------------------------------------------------------*/

void Inf_Inicia();
void Inf_Incrementa();
void Inf_Decrementa();
void Inf_DibujaMarco();
void Inf_ActualizaPantalla();

/*--------------------------------------------------------------------
 * Definicin de constantes
 *------------------------------------------------------------------*/

#define INF_PIEZAS 33  /* Piezas con que comienza la partida */

/*--------------------------------------------------------------------
 * Variables globales
 *------------------------------------------------------------------*/

extern contador Inf_Retiradas;
extern contador Inf_Mejor;

/*--------------------------------------------------------------------
 * Funciones definidas mediante macros
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * MACRO:    Inf_Inicia()
 * OBJETIVO: Dar valor inicial a la variable global Inf_Retiradas
 * ENTRADAS: Ninguna
 * SALIDAS:  La variable global Inf_Retirada queda modificada
 *------------------------------------------------------------------*/

#define Inf_Inicia()  (Inf_Retiradas=0)

#endif /* _INFORMACION_ */