/*--------------------------------------------------------------------
 * FICHERO:  Tab.h
 * OBJETIVO: Definir el objeto "Tablero" del programa Solitario
 * AUTOR:    Pedro Reina
 * FECHA:    D.8.3.1998
 * IDENTIFICADOR: Tab
 * FUNCIONES DISPONIBLES:
 *    Med()
 *    Tab_AlgunaCaptura()
 *    Tab_Celda()
 *    Tab_Colorea()
 *    Tab_Dibuja()
 *    Tab_DibujaMarco()
 *    Tab_DibujaPiezas()
 *    Tab_DibujaTodo()
 *    Tab_Disimula()
 *    Tab_HayPosibilidad()
 *    Tab_Inicia()
 *    Tab_Marca()
 *    Tab_Mueve()
 *    Tab_MueveAtras()
 *    Tab_PonCelda()
 *    Tab_PosVale()
 *    Tab_PuedeCapturar()
 *------------------------------------------------------------------*/

#ifndef _TABLERO_
#define _TABLERO_

/*--------------------------------------------------------------------
 * Ficheros de cabecera
 *------------------------------------------------------------------*/

#include <Olimpo.h>

/*--------------------------------------------------------------------
 * Declaracin de funciones
 *------------------------------------------------------------------*/

void Tab_Inicia();
void Tab_DibujaMarco();
void Tab_DibujaPiezas();
void Tab_Dibuja();
void Tab_Disimula();
void Tab_Colorea();
void Tab_Marca();
void Tab_Mueve();
void Tab_MueveAtras();
logico Tab_HayPosibilidad();
logico Tab_PuedeCapturar();
logico Tab_AlgunaCaptura();

/*--------------------------------------------------------------------
 * Definicin de constantes
 *------------------------------------------------------------------*/

#define TAB_CURSOR '#'

#define TAB_HUECO 0
#define TAB_PIEZA 1

#define TAB_DIM   7

/*--------------------------------------------------------------------
 * Estructura del tablero
 *------------------------------------------------------------------*/

extern logico Tab_Cuadro[TAB_DIM][TAB_DIM];

/*--------------------------------------------------------------------
 * Definicin de macros de acceso al tablero
 *------------------------------------------------------------------*/

#define Tab_Celda(f,c)       (Tab_Cuadro[f][c])
#define Tab_PonCelda(f,c,v)  (Tab_Cuadro[f][c]=(v))

/*--------------------------------------------------------------------
 * Macro general necesaria aqu
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * MACRO:    Med()
 * OBJETIVO: Calcular la media de dos nmeros
 * ENTRADAS: Dos nmeros. En este caso, sern siempre enteros y
 *                        de suma par
 * SALIDAS:  La media de ambos
 *------------------------------------------------------------------*/
#define Med(m,n)  (((m)+(n))/2)

/*--------------------------------------------------------------------
 * Funciones definidas mediante macros
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * MACRO:    Tab_PosVale()
 * OBJETIVO: Devuelve SI cuando la posicin es vlida
 *           Devuelve NO en caso contrario
 * ENTRADAS: Fila y columna de la posicin
 * SALIDAS:  Lgica
 *------------------------------------------------------------------*/
#define Tab_PosVale(f,c) ( ! ( (f)<2 && (c)<2 || (f)>4 && (c)>4 || \
                               (f)<2 && (c)>4 || (f)>4 && (c)<2 || \
                               (f)<0 || (f)>=TAB_DIM ||            \
                               (c)<0 || (c)>=TAB_DIM ) )

/*--------------------------------------------------------------------
 * MACRO:    Tab_DibujaTodo()
 * OBJETIVO: Dibujar el marco y las piezas
 * ENTRADAS: Ninguna
 * SALIDAS:  Ninguna
 *------------------------------------------------------------------*/
#define Tab_DibujaTodo() (Tab_DibujaMarco(),Tab_DibujaPiezas())

#endif /* _TABLERO_ */