;*-------------------------------------------------------------------
;* Fichero:  BlaNegr.scm
;* Objetivo: Convertir el blanco a negro
;* Autor:    Pedro Reina
;* Fecha:    M.18.7.2000
;*-------------------------------------------------------------------

;*-------------------------------------------------------------------
;* Definicin de la funcin principal de la funcin
;*-------------------------------------------------------------------

(
  define
    (
    script-fu-blanegr ; nombre de la funcin
    Imagen            ; Imagen con la que trabajamos
    Capa              ; La capa de trabajo
    )

    ; Seleccionamos el color 255, hallando la interseccin con
    ; la seleccin que ya est hecha
    (gimp-by-color-select Capa '(255 255 255) 1 3 FALSE 0 0.0 0)

    ; Ponemos "negro" como color de fondo
    (gimp-palette-set-background '(0 0 0))

    ; Borramos la zona seleccionada
    (gimp-edit-clear Capa)

    ; Anulamos la seleccin
    (gimp-selection-none Imagen)

    ; Actualizamos la representacin de pantalla
    (gimp-displays-flush)
)

;*-------------------------------------------------------------------
;* Registro de la funcin
;*-------------------------------------------------------------------

(script-fu-register
  "script-fu-blanegr"
  "<Image>/Script-Fu/StarOffice/BlancoNegro"
  "Cambia blanco a negro"
  "Pedro Reina <pedro@anit.es>"
  "Pedro Reina"
  "M.18.7.2000"
  "RGB* GRAY*"
  SF-IMAGE "Imagen" 0
  SF-DRAWABLE "Capa" 0
)
