;*-------------------------------------------------------------------
;* Fichero:  RecGris.scm
;* Objetivo: Recortar a la seleccin y convertirla a grises
;* Autor:    Pedro Reina
;* Fecha:    D.16.7.2000
;*-------------------------------------------------------------------

;*-------------------------------------------------------------------
;* Definicin de la funcin principal de la funcin
;*-------------------------------------------------------------------

(
  define
    (
    script-fu-recgris ; nombre de la funcin
    Imagen            ; Imagen con la que trabajamos
    Capa              ; Es obligatorio, aunque no lo uso
    )

    ; Comienzo de undo
    ;(gimp-undo-push-group-start) ; no s por qu, pero esto no funciona

    ; Calculamos la seleccin actual
    ; (Gracias a Adrian Likins, de "Selection to Image")
    (set! Seleccion (gimp-selection-bounds Imagen))
    (set! Izquierda (cadr Seleccion))
    (set! Arriba (caddr Seleccion))
    (set! Anchura (- (cadr (cddr Seleccion)) Izquierda))
    (set! Altura (- (caddr (cddr Seleccion)) Arriba))

    ; Nos quedamos con esa seleccin
    (gimp-crop Imagen Anchura Altura Izquierda Arriba)

    ; Convertimos a grises
    (gimp-convert-grayscale Imagen)

    ; Anulamos la seleccin
    (gimp-selection-none Imagen)

    ; Fin de undo
    (gimp-undo-push-group-end)
)

;*-------------------------------------------------------------------
;* Registro de la funcin
;*-------------------------------------------------------------------

(script-fu-register
  "script-fu-recgris"
  "<Image>/Script-Fu/StarOffice/RecGris"
  "Recorta a la seleccin y la convierte a grises"
  "Pedro Reina <pedro@anit.es>"
  "Pedro Reina"
  "D.16.7.2000"
  "RGB* GRAY*"
  SF-IMAGE "Imagen" 0
  SF-DRAWABLE "Capa" 0
)
