;*--------------------------------------------------------------------
;* Fichero:  curso.scm
;* Objetivo: Crear logotipos para el Curso de Informtica
;* Autor:    Pedro Reina <pedro@pedroreina.org>
;* Fecha:    D.17.2.2002
;*--------------------------------------------------------------------

;*--------------------------------------------------------------------
;* Este script se ha escrito a partir del script
;*   Bovinated Logos v0.1 04/08/98, de Brian McFee <keebler@wco.com>
;* con lneas del script
;*   Cool Metal, de Spencer Kimball & Rob Malda
;* Copyright: Dominio pblico (Public Domain)
;*--------------------------------------------------------------------

(define (script-fu-curso text size font gradient tamano autocrop-toggle flatten-toggle)
  (let* ((img (car (gimp-image-new 256 256 RGB)))
         (border (/ size 4))
         (text-layer (car (gimp-text-fontname img -1 0 0 text border TRUE size PIXELS font)))
         (width (car (gimp-drawable-width text-layer)))
         (height (car (gimp-drawable-height text-layer)))
         (bg-layer (car (gimp-layer-new img width height RGBA_IMAGE "Background" 100 NORMAL)))
         (blur-layer (car (gimp-layer-new img width height RGBA_IMAGE "Blur" 100 NORMAL)))
         (old-fg (car (gimp-palette-get-foreground)))
         (old-bg (car (gimp-palette-get-background)))
         (old-gradient (car (gimp-gradients-get-active))))
    (gimp-image-undo-disable img)
    (gimp-image-resize img width height 0 0)
    (gimp-image-add-layer img bg-layer 1)
    (gimp-image-add-layer img blur-layer 1)

    (gimp-selection-all img)
    (gimp-edit-fill bg-layer)
    (gimp-selection-none img)

    (gimp-layer-set-preserve-trans blur-layer TRUE)
    (gimp-palette-set-background '(255 255 255))
    (gimp-selection-all img)
    (gimp-edit-fill blur-layer)
    (gimp-edit-clear blur-layer)
    (gimp-selection-none img)
    (gimp-layer-set-preserve-trans blur-layer FALSE)
    (gimp-selection-layer-alpha text-layer)
    (gimp-edit-fill blur-layer)
;    (plug-in-gauss-rle 1 img blur-layer 5.0 1 1)
    (plug-in-gauss-rle 1 img blur-layer tamano 1 1)
    (gimp-selection-none img)
    (gimp-layer-set-preserve-trans text-layer TRUE)
    (gimp-selection-all img)
    (gimp-gradients-set-active gradient)
    (gimp-blend text-layer CUSTOM NORMAL LINEAR 100 0 REPEAT-NONE FALSE 0 0 0 0 0 height)
    (gimp-selection-none img)
    (gimp-layer-set-preserve-trans text-layer FALSE)
    (gimp-layer-set-name text-layer text)
    (plug-in-bump-map 1 img text-layer blur-layer 135 50 10 0 0 0 30 TRUE FALSE 0)
    (gimp-layer-set-offsets blur-layer 3 3)
    (gimp-invert blur-layer)
    (gimp-layer-set-opacity blur-layer 25.0)
    (gimp-image-set-active-layer img text-layer)

    (if (= autocrop-toggle TRUE)
      (plug-in-autocrop 1 img text-layer))

    (if (= flatten-toggle TRUE)
      (gimp-image-flatten img))

    (gimp-palette-set-background old-bg)
    (gimp-palette-set-foreground old-fg)
    (gimp-gradients-set-active old-gradient)
    (gimp-image-undo-enable img)
    (gimp-display-new img)))



(script-fu-register "script-fu-curso"
                    "<Toolbox>/Xtns/Script-Fu/Logos/Curso..."
                    "Logotipos para el curso"
                    "Pedro Reina <pedro@pedroreina.org>"
                    "Pedro Reina"
                    "Enero 2002"
                    ""
                    SF-STRING "Texto" "Informtica"
                    SF-ADJUSTMENT "Tamao de letra" '(80 2 1000 1 10 0 1)
                    SF-FONT "Fuente" "-*-drummon-bold-r-*-*-24-*-*-*-p-*-*-*"
                    SF-GRADIENT "Gradiente" "Curso"
                    SF-ADJUSTMENT "Tamao de 3D" '(5 1 100 1 10 0 1)
                    SF-TOGGLE "Autocrop?" FALSE
                    SF-TOGGLE "Aplanar imagen?" FALSE)
