;*-------------------------------------------------------------------
;* Fichero:  Marca3D.scm
;* Objetivo: Convertir a negro los colores del efecto 3D
;* Autor:    Pedro Reina
;* Fecha:    D.16.7.2000
;*-------------------------------------------------------------------

;*-------------------------------------------------------------------
;* Definicin de la funcin principal de la funcin
;*-------------------------------------------------------------------

(
  define
    (
    script-fu-marca3d ; nombre de la funcin
    Imagen            ; Imagen con la que trabajamos
    Capa              ; La capa de trabajo
    )

    ; Seleccionamos el color 223
    (gimp-by-color-select Capa '(223 223 223) 1 2 FALSE 0 0.0 0)

    ; Aadimos a la seleccin el color 127
    (gimp-by-color-select Capa '(127 127 127) 1 0 FALSE 0 0.0 0)
    ; No hace falta, pero es cmodo

    ; Ponemos "negro" como color de fondo
    (gimp-palette-set-background '(0 0 0))

    ; Borramos la zona seleccionada
    (gimp-edit-clear Capa)

    ; Anulamos la seleccin
    (gimp-selection-none Imagen)

    ; Actualizamos la representacin de pantalla
    (gimp-displays-flush)
)

;*-------------------------------------------------------------------
;* Registro de la funcin
;*-------------------------------------------------------------------

(script-fu-register
  "script-fu-marca3d"
  "<Image>/Script-Fu/StarOffice/Marca3D"
  "Marca los efectos 3D"
  "Pedro Reina <pedro@anit.es>"
  "Pedro Reina"
  "D.16.7.2000"
  "RGB* GRAY*"
  SF-IMAGE "Imagen" 0
  SF-DRAWABLE "Capa" 0
)
