;*-------------------------------------------------------------------
;* Fichero:  QuitFoco.scm
;* Objetivo: Quitar el color que indica foco
;* Autor:    Pedro Reina
;* Fecha:    X.9.8.2000
;*-------------------------------------------------------------------

;*-------------------------------------------------------------------
;* Definicin de la funcin principal de la funcin
;*-------------------------------------------------------------------

(
  define
    (
    script-fu-quitafoco ; nombre de la funcin
    Imagen              ; Imagen con la que trabajamos
    Capa                ; La capa de trabajo
    )

    ; Seleccionamos el color 64, hallando la interseccin con
    ; la seleccin que ya est hecha
    (gimp-by-color-select Capa '(64 64 64) 1 3 FALSE 0 0.0 0)

    ; Ponemos "gris plano" como color de fondo
    (gimp-palette-set-background '(191 191 191))

    ; Borramos la zona seleccionada
    (gimp-edit-clear Capa)

    ; Anulamos la seleccin
    (gimp-selection-none Imagen)

    ; Actualizamos la representacin de pantalla
    (gimp-displays-flush)
)

;*-------------------------------------------------------------------
;* Registro de la funcin
;*-------------------------------------------------------------------

(script-fu-register
  "script-fu-quitafoco"
  "<Image>/Script-Fu/StarOffice/QuitaFoco"
  "Elimina el color de foco"
  "Pedro Reina <pedro@anit.es>"
  "Pedro Reina"
  "X.9.8.2000"
  "RGB* GRAY*"
  SF-IMAGE "Imagen" 0
  SF-DRAWABLE "Capa" 0
)
