#! /bin/sh

#--------------------------------------------------------------------
# Fichero:  creaPDFdePS.sh
# Objetivo: Crear un archivo PDF a partir de uno o ms PostScript
# Autor:    Pedro Reina <pedro@pedroreina.org>
# Fecha:    D.30.9.2001
# Entradas: El primer parmetro es el nombre que se desea
#           dar al nuevo PDF; los dems parmetros son los
#           PS existentes
#--------------------------------------------------------------------

# Tomamos el primer parmetro
Destino=$1

# Descartamos el primer parmetro
shift

# Nos quedamos con todos los dems parmetros
Origen=$*

# Informamos al usuario
echo "Origen:  $Origen"
echo "Destino: $Destino"
echo -n Creando...

# La cracin real la hace ghostscript
gs -r600 -sDEVICE=pdfwrite -sOutputFile=$Destino -q -dNOPAUSE $Origen -c quit

# Se acab
echo " hecho."
