#!/bin/sh

#--------------------------------------------------------------------
# Fichero:  salva.sh
# Objetivo: Hacer copia de seguridad del curso
# Autor:    Pedro Reina <pedro@pedroreina.org>
# Fecha:    V.12.4.2002
#--------------------------------------------------------------------

DirectorioCurso=~/dat/curs0203
echo El directorio del curso es $DirectorioCurso

UnidadCopia=/mnt/zip
DirectorioCopia=$UnidadCopia/curs0203
echo El directorio de copias es $DirectorioCopia

# Montamos la unidad de copias
echo Montando $UnidadCopia
mount $UnidadCopia

# Salvamos los originales
echo Salvando...

cd $DirectorioCurso/original
for Parte in varios introduccion fundamentos tipografia gnulinux \
             windows internet staroffice draw image writer calc  \
             base multimedia creacionweb programacion
  do
    echo -n $Parte

    # Actualizamos el archivo zip con todos los archivos
    # de esa parte
    zip -9 -q -r -u ../seguridad/$Parte-orig.zip $Parte

    # Mostramos el resultado de la actualizacin
    Resultado=$?
    echo " -> $Resultado"

    # Copiamos el zip slo si es necesario
    if [ $Resultado -eq 0 ]
    then
      cp ../seguridad/$Parte-orig.zip $DirectorioCopia
    fi
  done

# Desmontamos la unidad de copias
echo Desmontando $UnidadCopia
umount $UnidadCopia

echo Terminado.
