#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  buscapal-genera.py
# Objetivo: Rellenar la base de datos de Buscapal
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    L.1.8.2011
# Licencia: GPLv2 (c) 1992 Pedro Reina y EQ Sistemas Inteligentes
#--------------------------------------------------------------------

#------------------------------------------------
# Variables del programa
#------------------------------------------------

# El archivo con las palabras
Origen = "palabra.txt"

# El archivo con la base de datos
Destino = "buscapal.db"

#------------------------------------------------
# Módulos necesarios
#------------------------------------------------

# Another Python SQLite Wrapper
import apsw

#------------------------------------------------
# El programa
#------------------------------------------------

# Informamos al usuario
print "Origen: " + Origen
print "Destino: " + Destino
print "Generando..."

# Abrimos el archivo de las palabras
Entrada = open (Origen, 'r')

# Abrimos la conexión a la base de datos
Conexion = apsw.Connection (Destino)

# Creamos un cursor para dialogar con la conexión
Cursor = Conexion.cursor()

# Leemos las palabras de una en una
for Palabra in Entrada:

  # Quitamos el fin de línea
  Clave = Palabra.strip()

  # Guardamos la palabra en UTF-8
  Palabra = unicode (Clave, encoding='utf-8')

  # Modificamos la clave
  Clave = Clave.replace ('á', 'a')
  Clave = Clave.replace ('é', 'e')
  Clave = Clave.replace ('í', 'i')
  Clave = Clave.replace ('ó', 'o')
  Clave = Clave.replace ('ú', 'u')
  Clave = Clave.replace ('ü', 'u')
  Clave = Clave.replace ('ñ', '+')

  # La longitud real es la de la clave
  Longitud = len (Clave)

  # Nos quedamos con las palabras entre 5 y 9 letras
  if ( Longitud >= 5 and Longitud <= 9 ):

    # Colocamos por orden las letras de la clave:
    # convertimos la cadena en lista, ordenamos la lista y volvemos
    # a generar la cadena
    ClaveLista = []
    for i in range (Longitud):
      ClaveLista.append(Clave[i])
    ClaveLista.sort()
    Clave = ""
    for Letra in ClaveLista:
      Clave += str(Letra)

    # Insertamos el registro en la base de datos
    Consulta = "INSERT INTO palabra" + str(Longitud) + \
               " VALUES (:Clave,:Palabra)"
    Cursor.execute (Consulta, locals())

# Cerramos la entrada
Entrada.close()

# Cerramos la conexión
Conexion.close (True)

# Informamos al usuario
print "Terminado."
