/*--------------------------------------------------------------------
 * Fichero:  calendariopr.c
 * Objetivo: Mostrar un sencillo calendario mensual
 * Autor:    Pedro Reina <pedro@anit.es>
 * Fecha:    V.13.7.2001
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * Este programa se ha escrito a partir de las instrucciones de
 * Michael J. Hammel en Linux Magazine edicin espaola n 7
 * Es mi primer intento de escribir un programa en C para GNOME
 * Copyright: Dominio pblico (Public Domain)
 *------------------------------------------------------------------*/


/*--------------------------------------------------------------------
 * Ficheros de cabecera
 *------------------------------------------------------------------*/

#include <gtk/gtk.h>


/*--------------------------------------------------------------------
 * Declaracin de funciones
 *------------------------------------------------------------------*/

void CerrarAplicacion (void);
void Hoy (GtkWidget *GtkWidget, gpointer Calendario);

int  Tim_Dia (void);            /* Devuelve el da del mes */
int  Tim_Mes (void);            /* Devuelve el mes */
int  Tim_Ano (void);            /* Devuelve el ao */


/*--------------------------------------------------------------------
 * Programa principal
 *------------------------------------------------------------------*/

int main (int Narg, char **Arg)
  {

  /*-----------------------------------
   * Controles GTK
   *---------------------------------*/

  GtkWidget *Ventana, *Caja, *CajaBotones, *Calendario,
            *BotonHoy, *BotonCerrar;


  /*-----------------------------------
   * Inicio de GTK
   *---------------------------------*/

  /* Queremos soporte internacional */
  gtk_set_locale();

  /* Iniciamos GTK */
  gtk_init (&Narg, &Arg);


  /*-----------------------------------
   * Ventana principal
   *---------------------------------*/

  /* Creamos la ventana principal */
  Ventana = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  /* Le ponemos un ttulo */
  gtk_window_set_title (GTK_WINDOW(Ventana), "CalendarioPR");


  /*-----------------------------------
   * Cajas contenedoras
   *---------------------------------*/

  /* Creamos una caja para colocar controles */
  Caja = gtk_vbox_new (FALSE, 0);

  /* Creamos una caja para colocar botones */
  CajaBotones = gtk_hbox_new (FALSE, 0);


  /*-----------------------------------
   * Calendario
   *---------------------------------*/

  /* Creamos un calendario */
  Calendario = gtk_calendar_new();

  /* Queremos que las semanas comiencen el lunes */
  gtk_calendar_display_options (GTK_CALENDAR(Calendario),
      GTK_CALENDAR_SHOW_HEADING +
      GTK_CALENDAR_SHOW_DAY_NAMES +
      GTK_CALENDAR_WEEK_START_MONDAY);

  /* Marcamos el da de hoy */
  gtk_calendar_select_day (GTK_CALENDAR(Calendario), Tim_Dia());


  /*-----------------------------------
   * Botones
   *---------------------------------*/

  /* Creamos el botn Cerrar */
  BotonCerrar = gtk_button_new_with_label ("Cerrar");

  /* Creamos el botn Hoy */
  BotonHoy = gtk_button_new_with_label ("Hoy");


  /*-----------------------------------
   * Colocacin de los componentes
   *---------------------------------*/

  /* Aadimos la caja a la ventana */
  gtk_container_add (GTK_CONTAINER(Ventana), Caja);

  /* Colocamos el calendario en la caja */
  gtk_box_pack_start (GTK_BOX (Caja), Calendario, FALSE, FALSE, 0);

  /* Colocamos la caja de botones en la caja */
  gtk_box_pack_start (GTK_BOX (Caja), CajaBotones, FALSE, FALSE, 0);

  /* Colocamos los botones en la caja de botones */
  gtk_box_pack_start (GTK_BOX (CajaBotones), BotonHoy, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (CajaBotones), BotonCerrar, TRUE, TRUE, 0);


  /*-----------------------------------
   * Tratamiento de seales
   *---------------------------------*/

  /* Al pulsar el botn Cerrar se cierra la aplicacin */
  gtk_signal_connect (GTK_OBJECT(BotonCerrar), "clicked",
                      GTK_SIGNAL_FUNC (CerrarAplicacion), (gpointer)0);

  /* Si el gestor de ventanas dice que hay que cerrar la aplicacin,
     la cerramos */
  gtk_signal_connect (GTK_OBJECT(Ventana), "destroy",
                      GTK_SIGNAL_FUNC (CerrarAplicacion), (gpointer)0);

  /* Al pulsar el botn Hoy se cambia el calendario al da de hoy */
  gtk_signal_connect (GTK_OBJECT(BotonHoy), "clicked",
                      GTK_SIGNAL_FUNC (Hoy), (gpointer)Calendario);


  /*-----------------------------------
   * Visualizacin
   *---------------------------------*/

  /* Mostramos los componentes */
  gtk_widget_show (BotonCerrar);
  gtk_widget_show (BotonHoy);
  gtk_widget_show (CajaBotones);
  gtk_widget_show (Calendario);
  gtk_widget_show (Caja);
  gtk_widget_show (Ventana);


  /*-----------------------------------
   * Dejamos a otro el resto
   *---------------------------------*/

  /* Bucle principal GTK */
  gtk_main();

  /* Hemos terminado */
  return ( 0 );
  }


/*--------------------------------------------------------------------
 * Definicin de funciones
 *------------------------------------------------------------------*/

/*--------------------------------------------------------------------
 * Funcin:  CerrarAplicacion()
 * Objetivo: Cerrar la aplicacin GTK
 * Entradas: Ninguna
 * Salidas:  Ninguna
 * Tipo Ent: void
 * Tipo Sal: void
 * Nota:     Esta funcin debe ser invocada por GTK
 * Ejemplo:  gtk_signal_connect (GTK_OBJECT(BotonCerrar), "clicked",
 *               GTK_SIGNAL_FUNC (CerrarAplicacion), (gpointer)0);
 *------------------------------------------------------------------*/

void CerrarAplicacion (void)
  {
  exit();
  }

/*--------------------------------------------------------------------
 * Funcin:  Hoy()
 * Objetivo: Poner un calendario en el da de hoy
 * Entradas: El botn que recibe la orden y el calendario
 * Salidas:  Ninguna
 * Tipo Ent: GtkWidget *, gpointer
 * Tipo Sal: void
 * Ejemplo:  Hoy (Calendario)
 *------------------------------------------------------------------*/

void Hoy (GtkWidget *Boton, gpointer Calendario)
  {
  /* Para GTK, Enero es el mes 0; para Tim_Mes(), es el 1 */
  gtk_calendar_select_month (GTK_CALENDAR(Calendario),
                             Tim_Mes()-1, Tim_Ano());

  gtk_calendar_select_day (GTK_CALENDAR(Calendario), Tim_Dia());
  }
