//-------------------------------------------------------------------------
// Fichero:  Aleatorio.java
// Objetivo: Implementar la clase Aleatorio
// Fecha:    S.8.9.2007
// Autor:    Pedro Reina <pedro@pedroreina.net>
// Licencia: GPLv3 http://www.gnu.org/licenses/gpl.html
//-------------------------------------------------------------------------

// Paquetes necesarios

import java.lang.*;
import java.util.Random;             // Para generar números aleatorios

// Clase Aleatorio

class Aleatorio
  {
  // Variables de la clase
  private Random GeneradorAleatorio;

  // Constructor de la clase
  public Aleatorio()
    {
    // Iniciamos el generador aleatorio
    GeneradorAleatorio = new Random();
    }

  // Función que devuelve un número con la cantidad de cifras pedida
  public String InventaNumero (int Longitud)
    {
    int Numero, Maximo, Minimo, Rango;
    Integer NumeroRespuesta;
    String Respuesta;

    Minimo = DiezElevado (Longitud-1);
    Maximo = 10 * Minimo;
    Rango = Maximo - Minimo;
    Numero = Math.abs(GeneradorAleatorio.nextInt()) % Rango;
    Numero += Minimo;

    NumeroRespuesta = new Integer (Numero);
    Respuesta = NumeroRespuesta.toString();

    return Respuesta;
    }

  // Función que devuelve 10 elevado al exponente, que debe ser
  // positivo y natural
  private int DiezElevado (int Exponente)
    {
    int Respuesta=1, i;
    
    for ( i=0 ; i<Exponente ; i++ )
      { Respuesta *= 10; }

    return Respuesta;
    }
  
  }
