//-------------------------------------------------------------------------
// Fichero:  Lienzo.java
// Objetivo: Implementar la clase Lienzo
// Fecha:    M.18.9.2007
// Autor:    Pedro Reina <pedro@pedroreina.net>
// Licencia: GPLv3 http://www.gnu.org/licenses/gpl.html
//-------------------------------------------------------------------------

// Paquetes necesarios

import java.lang.*;
import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;

// Clase Lienzo

class Lienzo extends Canvas
  {
  // Constantes
  public final int Margen = 5;
  private String Titulo = "Segundero";
  
  // Variables de la clase
  public Font FuenteGrande, FuenteMediana;
  public int Anchura, Altura, AlturaUtil, AlturaCabecera, Avance;
  private int Posicion;

  // Constructor de la clase
  public Lienzo()
    {
    // Elegimos las fuentes de letras
    FuenteGrande = Font.getFont (Font.FACE_PROPORTIONAL,
                   Font.STYLE_BOLD, Font.SIZE_LARGE);
    FuenteMediana = Font.getFont (Font.FACE_PROPORTIONAL,
                    Font.STYLE_PLAIN, Font.SIZE_MEDIUM);
    
    // Dimensiones de la pantalla
    Anchura = getWidth();
    Altura = getHeight();

    // Altura de una línea
    Avance = FuenteMediana.getHeight();
    
    // Altura de la pantalla que queda libre
    AlturaUtil = Altura - Avance - Margen;
    
    // Altura de la cabecera
    AlturaCabecera = Avance + Margen;
    
    // Posición para centrar el título
    Posicion = (Anchura - FuenteGrande.stringWidth (Titulo)) / 2;
    }
  
  public void paint (Graphics Graf)
    {
    // Borramos la pantalla con blanco
    Graf.setColor (255, 255, 255);
    Graf.fillRect (0, 0, Anchura, Altura);

    // Pintamos un rectángulo azul oscuro arriba
    Graf.setColor (0, 0, 100);
    Graf.fillRect (0, 0, Anchura, AlturaCabecera);

    // Escribimos el título en blanco
    Graf.setColor (255, 255, 255);
    Graf.setFont (FuenteGrande);
    Graf.drawString (Titulo, Posicion, 0, 0);

    // Dejamos color negro
    Graf.setColor (0, 0, 0);
    }
  }
