//-------------------------------------------------------------------------
// Fichero:  LienzoMostrar.java
// Objetivo: Implementar la clase LienzoMostrar
// Fecha:    M.18.9.2007
// Autor:    Pedro Reina <pedro@pedroreina.net>
// Licencia: GPLv3 http://www.gnu.org/licenses/gpl.html
//-------------------------------------------------------------------------

// Paquetes necesarios

import java.lang.*;
import java.util.*;
import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;

// Clase LienzoMostrar

class LienzoMostrar extends Lienzo
  {
  // Varibles de la clase
  private String Numero;
  private Image Logo;
  private Display Pantalla;
  private Displayable Siguiente;
  private Timer Terminador;
  
  // Constructor de la clase
  public LienzoMostrar (Display Pant)
    {
    // Nos quedamos con el manejador de la pantalla del MIDlet 
    Pantalla = Pant;
    
    // Cargamos el logo en memoria
    try
      { Logo = Image.createImage("/Segundero.png"); }
    catch (Exception Excepcion)
      { System.err.println ("Error: " + Excepcion); }
    }

  public void setNumero (String Cadena)
    { Numero = Cadena; }
    
  public void setSiguiente (Displayable Pant)
    { Siguiente = Pant; }
    
  public void paint (Graphics Graf)
    {
    int LongitudTexto;
    
    // Longitud del texto que hay que escribir
    LongitudTexto = FuenteGrande.stringWidth (Numero);

    // Llamamos al método general
    super.paint (Graf);    

    // Ponemos el logo del juego
    Graf.drawImage (Logo, Margen, Altura - AlturaUtil + Margen, 0);
    
    // Escribimos el número centrado en la pantalla
    Graf.setFont (FuenteGrande);
    Graf.drawString (Numero, (Anchura-LongitudTexto)/2, 
                     Avance + Margen + AlturaUtil/2, 0);
    }
  
  protected void showNotify()
    {
    // Cuando el sistema nos dice que estamos a punto de aparecer en pantalla,
    // creamos un temporizador que nos haga desaparecer al cabo de un segundo.
    Terminador = new Timer();
    Terminador.schedule (new Contador(), 1000);
    }  

  private void Terminar()
    {
    // Para terminar, cancelamos el temporizador
    Terminador.cancel();
    
    // Y pasamos a la siguente pantalla
    Pantalla.setCurrent (Siguiente);
    }

  private class Contador extends TimerTask
    {
    public void run()
      { Terminar(); }
    }   
  }
