//-------------------------------------------------------------------------
// Fichero:  LienzoPedirLongitud.java
// Objetivo: Implementar la clase LienzoPedirLongitud
// Fecha:    M.18.9.2007
// Autor:    Pedro Reina <pedro@pedroreina.net>
// Licencia: GPLv3 http://www.gnu.org/licenses/gpl.html
//-------------------------------------------------------------------------

// Paquetes necesarios

import java.lang.*;
import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;

// Clase LienzoPedirLongitud

class LienzoPedirLongitud extends Lienzo
  {
  private int Longitud;

  public int getLongitud()
    { return Longitud; }

  // Constructor de la clase
  public LienzoPedirLongitud()
    { Longitud = 1; }
  
  public void paint (Graphics Graf)
    {
    // Llamamos al método general
    super.paint (Graf);
    
    // Mostramos la explicación
    Graf.setFont (FuenteMediana);
    Graf.drawString ("Elige la longitud", Margen, 2*Avance, 0);
    Graf.drawString ("del primer número", Margen, 3*Avance, 0);
    Graf.drawString ("(de 1 a 10)", Margen, 4*Avance, 0);

    // Mostramos la longitud
    Graf.setFont (FuenteGrande);
    Graf.drawString ((new Integer(Longitud)).toString(), (Anchura)/2, Altura-2*Avance, 0);
    }
    
  public void keyPressed (int CodigoTecla)
    {
    switch (CodigoTecla)
      {
      case KEY_NUM0: Longitud = 10; break;
      case KEY_NUM1: Longitud = 1;  break;
      case KEY_NUM2: Longitud = 2;  break;
      case KEY_NUM3: Longitud = 3;  break;
      case KEY_NUM4: Longitud = 4;  break;
      case KEY_NUM5: Longitud = 5;  break;
      case KEY_NUM6: Longitud = 6;  break;
      case KEY_NUM7: Longitud = 7;  break;
      case KEY_NUM8: Longitud = 8;  break;
      case KEY_NUM9: Longitud = 9;  break;
      }

    // Actualizamos la pantalla
    repaint();
    serviceRepaints();
    }
  }
