//-------------------------------------------------------------------------
// Fichero:  LienzoPedirNumero.java
// Objetivo: Implementar la clase LienzoPedirNumero
// Fecha:    M.18.9.2007
// Autor:    Pedro Reina <pedro@pedroreina.net>
// Licencia: GPLv3 http://www.gnu.org/licenses/gpl.html
//-------------------------------------------------------------------------

// Paquetes necesarios

import java.lang.*;
import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;

// Clase LienzoPedirNumero

class LienzoPedirNumero extends Lienzo
  {
  private StringBuffer Numero;

  public String getNumero()
    { return new String (Numero); }
  
  public void borraNumero()
    { Numero = new StringBuffer(); }
  
  public void paint (Graphics Graf)
    {
    int LongitudTexto;

    // Longitud del texto que hay que escribir
    LongitudTexto = FuenteGrande.stringWidth (Numero.toString());
    
    // Llamamos al método general
    super.paint (Graf);
    
    // Mostramos la explicación
    Graf.setFont (FuenteMediana);
    Graf.drawString ("Escribe el número", Margen, 2*Avance, 0);
    Graf.drawString ("que acabas de ver", Margen, 3*Avance, 0);
    Graf.drawString ("(usa * para borrar)", Margen, 4*Avance, 0);

    // Mostramos el número
    Graf.setFont (FuenteGrande);
    Graf.drawString (Numero.toString(), (Anchura-LongitudTexto)/2, Altura-2*Avance, 0);
    }
    
  public void keyPressed (int CodigoTecla)
    {
    switch (CodigoTecla)
      {
      case KEY_NUM0: Numero.append('0'); break;
      case KEY_NUM1: Numero.append('1'); break;
      case KEY_NUM2: Numero.append('2'); break;
      case KEY_NUM3: Numero.append('3'); break;
      case KEY_NUM4: Numero.append('4'); break;
      case KEY_NUM5: Numero.append('5'); break;
      case KEY_NUM6: Numero.append('6'); break;
      case KEY_NUM7: Numero.append('7'); break;
      case KEY_NUM8: Numero.append('8'); break;
      case KEY_NUM9: Numero.append('9'); break;

      case KEY_STAR:
        if ( Numero.length() > 0 )
          { Numero.deleteCharAt (Numero.length()-1); }
        break;
      }

    // Actualizamos la pantalla
    repaint();
    serviceRepaints();
    }
  }
