//-------------------------------------------------------------------------
// Fichero:  Segundero.java
// Objetivo: Implementar el juego Segundero para móviles con Java
// Fecha:    M.18.9.2007
// Autor:    Pedro Reina <pedro@pedroreina.net>
// Licencia: GPLv3 http://www.gnu.org/licenses/gpl.html
//-------------------------------------------------------------------------

// Paquetes necesarios

import java.lang.*;
import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;

// Clase Segundero

public class Segundero extends MIDlet implements CommandListener
  {
  // Constantes
  private final int MaxTurno = 10;
  private final int MaxLongitud = 10;
  private final int PuntosAcierto[] = {0, 1, 2, 3, 5, 7, 11, 15, 22, 30};

  // Variables necesarias para el GUI
  private Display Pantalla;
  private LienzoExplicacion Explicacion;
  private LienzoPedirNumero PedirNumero;
  private LienzoPedirLongitud PedirLongitud;
  private Info MostrarPuntos;
  private LienzoMostrar MostrarNumero;
  private Command Salir, Jugar, Anular, Empezar, Seguir, Visto;

  // Variables necesarias para el juego
  private Aleatorio Generador;
  private int Longitud, Turno, Puntos;
  private String Numero, Contestado;
  private StringBuffer Resultado;

  // Constructor de la clase
  public Segundero()
    {
    // Obtenemos el objeto Display del midlet.
    Pantalla = Display.getDisplay (this);

    // Preparamos el generador de números aleatorios
    Generador = new Aleatorio();

    // Creamos las órdenes
    Salir = new Command ("Salir", Command.EXIT, 1);
    Anular = new Command ("Anular", Command.EXIT, 1);
    Jugar = new Command ("Jugar", Command.OK, 2);
    Empezar = new Command ("Empezar", Command.OK, 2);
    Seguir = new Command ("Seguir", Command.OK, 2);
    Visto = new Command ("Visto", Command.OK, 2);

    // Creamos los canvas
    Explicacion = new LienzoExplicacion();
    PedirLongitud = new LienzoPedirLongitud();
    PedirNumero = new LienzoPedirNumero();
    MostrarNumero = new LienzoMostrar (Pantalla);
    MostrarPuntos = new Info();

    // Siempre que mostremos un número, lo pediremos a continuación
    MostrarNumero.setSiguiente (PedirNumero);
 
    // Añadimos las órdenes e indicamos qué clase las manejará
    Explicacion.addCommand (Salir);
    Explicacion.addCommand (Jugar);
    Explicacion.setCommandListener (this);
    PedirLongitud.addCommand (Anular);
    PedirLongitud.addCommand (Empezar);
    PedirLongitud.setCommandListener (this);
    PedirNumero.addCommand (Anular);
    PedirNumero.addCommand (Seguir);
    PedirNumero.setCommandListener (this);
    MostrarPuntos.addCommand (Visto);
    MostrarPuntos.setCommandListener (this);
    }

  public void startApp() throws MIDletStateChangeException
    {
    // Seleccionamos lo primero que hay que mostrar
    Pantalla.setCurrent (Explicacion);
    }

  public void commandAction (Command Orden, Displayable s) 
    {
    if ( Orden == Salir )
      {
      destroyApp (false);
      notifyDestroyed();
      }

    if ( Orden == Anular )
      { Pantalla.setCurrent (Explicacion); }

    if ( Orden == Visto )
      { Pantalla.setCurrent (Explicacion); }

    if ( Orden == Jugar )
      {
      // Damos valores iniciales a las variables del juego
      Turno = 0;
      Puntos = 0;
      Resultado = new StringBuffer();

      // Pedimos la longitud del primer número
      Pantalla.setCurrent (PedirLongitud);
      }

    if ( Orden == Empezar )
      {
      // Anotamos la longitud que ha elegido el usuario
      Longitud = PedirLongitud.getLongitud();

      // Mostramos y pedimos el primer número
      JuegaTurno();
      }

    if ( Orden == Seguir )
      {
      // Vemos qué numero ha contestado el usuario
      Contestado = PedirNumero.getNumero();

      // Según el usuario haya acertado o no
      if ( Contestado.regionMatches (false, 0, Numero, 0, Longitud) )
        {
        // Esto es un acierto
        Resultado.append ('1');
        Puntos += PuntosAcierto[Longitud-1];
        Longitud++;
        }
      else
        {
        // Esto es un fallo
        Resultado.append ('0');
        Puntos -= PuntosAcierto[MaxLongitud-Longitud];
        Longitud--;
        }

      // Vemos si hay que seguir jugando o no
      Turno++;
      if ( Turno == MaxTurno )
        {
        // Hemos acabado de jugar, hay que mostrar el resultado y los puntos
        MostrarPuntos.setResultado (Resultado);
        MostrarPuntos.setPuntos (Puntos);
        Pantalla.setCurrent (MostrarPuntos);
        }

      else  // Seguimos jugando
        {
        // Cuidamos que la longitud no se salga de límites
        if ( Longitud == 0 )
          { Longitud = 1; }
        if ( Longitud > MaxLongitud )
          { Longitud = MaxLongitud; }

        // Lanzamos y pedimos el siguiente número
        JuegaTurno();
        }
      }
    }

  // Función que prepara un turno de juego
  public void JuegaTurno()
    {
    Numero = Generador.InventaNumero (Longitud);
    MostrarNumero.setNumero (Numero);
    PedirNumero.borraNumero();
    Pantalla.setCurrent (MostrarNumero);
    }

  public void pauseApp() {}

  public void destroyApp (boolean incondicional) {}

  }
