#!/bin/sh

#--------------------------------------------------------------------
# Fichero:  mgp-prepara.sh
# Objetivo: Preparar todos los archivos necesarios para utilizar
#           una presentacin Magic Point
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    J.11.8.2005
#--------------------------------------------------------------------

# Clave de la presentacin
Presentacion=$1

# (Suponemos que partimos de estar situados en el
# directorio de la presentacin)

# Eliminamos los directorios de apoyo
rm -rf html imagen final

# Hacemos una copia de todos los archivos
tar cvzf $Presentacion.tgz *

# Creamos un directorio para los archivos comprimidos
mkdir final

# Guardamos el archivo comprimido
mv $Presentacion.tgz final

# Creamos un directorio para los archivos HTML
mkdir html

# Creamos un directorio para las imgenes PNG
mkdir imagen

# Ejecutamos la presentacin para que genere
# archivos HTML e imgenes PNG
mgp-x-m17n -g 800x600 -D html -E png $Presentacion.mgp

# Castellanizamos los archivos generados
mgp-castellanizar.pl $Presentacion html

# Copiamos las imgenes grandes creadas al directorio de imgenes
cp html/$Presentacion??.png imagen

# Comprimimos las imgenes y guardamos el archivo
cd imagen
zip $Presentacion.zip *
mv $Presentacion.zip ../final
