<!--
**********************************************************************
* Fichero:  nuevo.php
* Objetivo: Añadir un comentario en el libro de visitas
* Fecha:    X.10.2.2016
* Autor:    Pedro Reina <pedro@pedroreina.net>
* Licencia: CC0 1.0 Universal
*           https://creativecommons.org/publicdomain/zero/1.0/
**********************************************************************
-->

<?php
  require 'visita.php';
  Tedecea_EmiteDTD ('HTML401strict');
?>

<HTML>

<?php
  Tedecea_EmiteCabecera ($Titulo, 'UTF-8');
  Tedecea_EmiteLogotipo();
?>

<!-- Presentación -->

<DIV CLASS="cuadro">

  <DIV CLASS="titulo1">Escribir comentario</DIV>

</DIV>

<!-- Núcleo de la página -->

<?php MuestraNucleo(); ?>

<!-- Otras posibilidades -->

<?php EscribeFinal(); ?>

<!-- Fin de página web -->

</BODY>

</HTML>

<!-- Programa PHP -->

<?php

// Rutina principal
function MuestraNucleo()
  {
  if ( count ($_POST) )
    { MuestraRespuesta(); }
  else
    { MuestraFormulario(); }
  }

// ----------------------------

// Rutina para mostrar el formulario
function MuestraFormulario()
  {
  $YoMismo = $_SERVER['PHP_SELF'];

  $CodigoHTML=<<<HTML

  <DIV CLASS="cuadro">

    <DIV CLASS="titulo2">Escribe tu nombre y comentario</DIV>

    <DIV CLASS="contenido">

    <FORM ACTION="$YoMismo" METHOD="POST">
    <TR><TD>
    <TABLE WIDTH="100%">
      <TR ALIGN="CENTER"><TD>Nombre: <INPUT NAME="nombre" SIZE="40"></TD></TR>
      <TR ALIGN="CENTER"><TD><P>Comentario:
      <P><TEXTAREA COLS="60" ROWS="10"
          NAME="comentario" WRAP="virtual"></TEXTAREA>
      </TD></TR>
      <TR ALIGN="CENTER">
      <TD>
        <INPUT TYPE="submit" VALUE=" Enviar ">
        <INPUT TYPE="reset" VALUE=" Borrar ">
      </TD>
      </TR>
    </TD></TR>
    </TABLE>
    </FORM>

    </DIV>

  </DIV>

HTML;
  print $CodigoHTML;
  }

// ----------------------------

// Rutina para mostrar la respuesta
function MuestraRespuesta()
  {
  global $Archivo, $CorreoAdmin, $URLadmin;

  // Tomamos los datos del formulario
  $Nombre = $_POST['nombre'];
  $Comentario = $_POST['comentario'];

  // Los limpiamos
  $Nombre = trim($Nombre);
  $Comentario = trim($Comentario);

  if ( $Nombre == '' )
    { $Mensaje = "<B>Error:</B> no has escrito tu nombre"; }
  else
    {
    if ( $Comentario == '' )
      { $Mensaje = "<B>Error:</B> no has escrito comentario"; }
    else
      {
      // Averiguamos la IP del que deja el comentario
      $IP = Tedecea_AveriguaIP();

      // Retocamos el Nombre y el Comentario
      $NuevaLinea = array ("\r\n", "\n", "\r");
      $Break = '<BR>';
      $Nombre = str_replace ($NuevaLinea, $Break, $Nombre);
      $Comentario = str_replace ($NuevaLinea, $Break, $Comentario);

      // Almacenamos el comentario en la base de datos
      $Consulta = "INSERT INTO visita (nombre, comentario, ip) " .
                  "VALUES ('$Nombre', '$Comentario', '$IP')";
      $Error = TedeceaBD_EjecutaConsulta($Archivo, $Consulta);

      // Informamos al usuario
      if ( $Error )
        {
        $Mensaje = "Lo sentimos, <B>$Nombre</B>, ha habido un error. " .
                   "Por favor, inténtalo más tarde.";
        }

      else
        {
        $Mensaje = "Gracias, <B>$Nombre</B>, tu comentario ha sido añadido " .
                   "al libro de visitas y aparecerá cuando sea aprobado.";

        // Informamos al administrador
        $Cabeceras = "Content-Type: text/plain; charset=UTF-8\r\n";
        $Cabeceras .= "X-Mailer: PHP";
        mail ($CorreoAdmin, "Comentario en el libro de visitas",
              "Lo envía: $Nombre\nAdministración: $URLadmin", $Cabeceras);
        }
      }
    }

  print "<DIV CLASS=\"cuadro\">\n";
  print "<DIV CLASS=\"titulo2\">Resultado de la operación</DIV>\n";
  print "<DIV CLASS=\"contenido\">$Mensaje</DIV>\n";
  print "</DIV>\n";
  }

// ----------------------------

// Rutina para mostrar vínculos a otras páginas
function EscribeFinal()
  {
  $OpcionNuevo = array ('Introducir un comentario', 'nuevo.php');
  $OpcionVer = array ('Leer los comentarios que hay en el libro de visitas',
                      'ver.php');
  $OpcionLibro = array ('Volver a la página principal del libro', '.');

  if ( count ($_POST) )
    { Tedecea_Seguir($OpcionVer, $OpcionNuevo, $OpcionLibro); }
  else
    { Tedecea_Seguir($OpcionVer, $OpcionLibro); }
  }

?>
